# This file is part of lib6300, software for use in MIT's 6.300
# Copyright (c) 2018-2019 by the 6.300 Staff <6.300-core@mit.edu>
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program.  If not, see <https://www.gnu.org/licenses/>.

import os

from setuptools import setup

from lib6300 import __version__ as VERSION


def main():
    with open(os.path.join(os.path.dirname(__file__), "requirements.txt"), "r") as f:
        requirements = f.read().split("\n")

    with open(os.path.join(os.path.dirname(__file__), "README"), "r") as f:
        readme = f.read()

    setup(
        name="lib6300",
        version=VERSION,
        author="adam hartz",
        author_email="hz@mit.edu",
        packages=["lib6300"],
        scripts=[],
        url="https://sigproc.mit.edu",
        license="GPLv3+",
        description="Software for 6.300",
        long_description=readme,
        include_package_data=True,
        entry_points={},
        install_requires=requirements,
        package_dir={"lib6300": "lib6300"},
    )


if __name__ == "__main__":
    main()
